<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PocketShared extends Model 
{

    protected $table = 'pockets_shared';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'pocket_id', 'friend_user_id', 'name', 'isHistory', 'timestamps', 'softDeletes');

    public function pockets()
    {
        return $this->belongsTo('App\Models\Pocket', 'pockets_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function with_user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

}